#pragma once

#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/rt_background/common/state.h>
#include <drive/backend/rt_background/manager/settings.h>

#include <rtline/util/types/accessor.h>

class TRTMailSubscriptionWatcherState : public TRTHistoryWatcherState {
    static TFactory::TRegistrator<TRTMailSubscriptionWatcherState> Registrator;
protected:
    virtual TString GetType() const;
};

class TRTMailSubscriptionWatcher: public IRTRegularBackgroundProcess {
    R_READONLY(TSet<TString>, SubscriptionLists);
    R_READONLY(TString, TagName);
    R_READONLY(TString, FieldName);
    R_READONLY(size_t, Limit, 10000);
    R_READONLY(ui64, StartEventId, 0);
    R_READONLY(TString, EmailValidationRegex, "^[A-Za-z0-9.!#$%&'*+\\/=?^_`{|}~-]+@[\\w\\d](?:[\\w\\d-]{0,61}[\\w\\d])?(?:\\.[\\w\\d](?:[\\w\\d-]{0,61}[\\w\\d])?)*$");

private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TRTMailSubscriptionWatcher> Registrator;

public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "mail_subscription_watcher";
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
};
