#pragma once
#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/rt_background/sensor_tags/config.h>

#include <drive/backend/background/manager/regular.h>
#include <drive/backend/proto/background.pb.h>
#include <drive/backend/major/client.h>

#include <rtline/library/time_restriction/time_restriction.h>
#include <rtline/util/types/accessor.h>

class TRTMajorTOSynchronizerWatcher: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TRTMajorTOSynchronizerWatcher> Registrator;
protected:
    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> /*state*/, const TExecutionContext& context) const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    using TBase::TBase;

    static TString GetTypeName() {
        return "major_maintenance_synchronizer";
    }
};

class TMajorWatcherContext: public IRTSensorToTagsWatcher::TSensorWatcherContext {
public:
    using TBase = IRTSensorToTagsWatcher::TSensorWatcherContext;
    enum class ENeedMaintenance {
        InProgress,
        Need,
        Ready
    };

public:
    using TBase::TBase;
    virtual bool Init(const NDrive::IServer& server) override;
    virtual TMaybe<IRTSensorToTagsWatcher::ESpecialAction> CheckDevice(const TString& carId, const double value) const override;
    TMaybe<ENeedMaintenance> CheckNeedMaintenance(const double currentMileage, ui32& maintenanceNumber, const TMaintenanceInfo* info) const;

private:
    R_FIELD(double, MaintenancePrecisionHistory, 3000);
    R_FIELD(double, MaintenancePrecisionNew, 1500);
    R_FIELD(ui32, MaintenancePoint, 0);
    R_FIELD(TVector<ui32>, MaintenancePoints);
    TMap<TString, TMaintenanceInfo> MaintenanceInfo;
};

class TRTMajorMaintenanceWatcher: public IRTSensorToTagsWatcherTemplate<TMajorWatcherContext> {
private:
    using TBase = IRTSensorToTagsWatcherTemplate<TMajorWatcherContext>;

private:
    static const TVector<ui32> DefaultMaintenancePoints;
    R_FIELD(double, MaintenancePrecisionHistory, 3000);
    R_FIELD(double, MaintenancePrecisionNew, 1500);
    R_FIELD(ui32, MaintenancePoint, 0);
    R_FIELD(TVector<ui32>, MaintenancePoints, DefaultMaintenancePoints);
    static TFactory::TRegistrator<TRTMajorMaintenanceWatcher> Registrator;

public:

    virtual TString GetType() const override {
        return GetTypeName();
    }

    using TBase::TBase;

    static TString GetTypeName() {
        return "major_maintenance_watcher";
    }
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

private:
    virtual bool CustomizeWatcherContext(TMajorWatcherContext& watcherContext) const override {
        watcherContext.SetMaintenancePrecisionHistory(MaintenancePrecisionHistory);
        watcherContext.SetMaintenancePrecisionNew(MaintenancePrecisionNew);
        watcherContext.SetMaintenancePoints(MaintenancePoints);
        watcherContext.SetMaintenancePoint(MaintenancePoint);
        return true;
    }
};

class TRTMajorNewCarProcess : public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;
    R_READONLY(TString, NotifierName);
    R_READONLY(bool, NotificationOnly, true);
    static TFactory::TRegistrator<TRTMajorNewCarProcess> Registrator;
protected:
    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> /*state*/, const TExecutionContext& context) const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    using TBase::TBase;

    static TString GetTypeName() {
        return "major_new_car";
    }
};

class TRTMajorCheckCarsProcess : public IRTCarsProcess {
private:
    using TBase = IRTCarsProcess;
    R_READONLY(TString, NotifierName);
    static TFactory::TRegistrator<TRTMajorCheckCarsProcess> Registrator;
protected:
    virtual TExpectedState DoExecuteFiltered(TAtomicSharedPtr<IRTBackgroundProcessState> /*state*/, const NDrive::IServer& server, TTagsModificationContext& context) const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    using TBase::TBase;

    static TString GetTypeName() {
        return "major_check_car";
    }
};
