#include "config.h"

#include <rtline/util/instant_model.h>

#include <library/cpp/mediator/global_notifications/system_status.h>


void TRTBackgroundManagerConfig::Init(const TYandexConfig::Section* section) {
    const auto& directives = section->GetDirectives();
    ThreadsCount = directives.Value("ThreadsCount", ThreadsCount);
    DBName = directives.Value("DBName", DBName);
    AssertCorrectConfig(!!DBName, "Incorrect DBName for rt background manager");
    LockDbName = directives.Value("LockDbName", LockDbName);
    LockDb2Name = directives.Value("LockDb2Name", LockDb2Name);
    PingPeriod = directives.Value("PingPeriod", PingPeriod);
    FinishAttemptionsTimeout = directives.Value("FinishAttemptionsTimeout", FinishAttemptionsTimeout);
    FinishAttemptionsPause = directives.Value("FinishAttemptionsPause", FinishAttemptionsPause);
    TString blockedProcessesStr;
    blockedProcessesStr = directives.Value("BlockedProcesses", blockedProcessesStr);
    BlockedProcesses = StringSplitter(blockedProcessesStr).SplitBySet(", ").SkipEmpty();
    HistoryConfig.Init(section);
    auto children = section->GetAllChildren();
    if (auto it = children.find("Propositions"); it != children.end()) {
        PropositionsConfig.Init(it->second);
    }
}

void TRTBackgroundManagerConfig::ToString(IOutputStream& os) const {
    os << "ThreadsCount: " << ThreadsCount << Endl;
    os << "DBName: " << DBName << Endl;
    os << "LockDbName: " << LockDbName << Endl;
    os << "LockDb2Name: " << LockDb2Name << Endl;
    os << "PingPeriod: " << PingPeriod << Endl;
    os << "FinishAttemptionsTimeout: " << FinishAttemptionsTimeout << Endl;
    os << "FinishAttemptionsPause: " << FinishAttemptionsPause << Endl;
    os << "BlockedProcesses: " << JoinSeq(",", BlockedProcesses) << Endl;
    HistoryConfig.ToString(os);
    os << "<Propositions>" << Endl;
    PropositionsConfig.ToString(os);
    os << "</Propositions>" << Endl;
}
