#pragma once

#include <drive/backend/database/history/config.h>
#include <drive/backend/database/history/propositions.h>

#include <drive/library/cpp/scheme/scheme.h>

#include <library/cpp/yconf/conf.h>

#include <rtline/util/types/accessor.h>
#include <rtline/util/types/range.h>

#include <util/datetime/base.h>
#include <util/stream/output.h>

class TRTBackgroundManagerConfig {
    R_READONLY(ui32, ThreadsCount, 16);
    R_READONLY(TString, DBName);
    R_READONLY(TString, LockDbName);
    R_READONLY(TString, LockDb2Name);
    R_READONLY(THistoryConfig, HistoryConfig);
    R_READONLY(TDuration, PingPeriod, TDuration::Seconds(10));
    R_READONLY(TDuration, FinishAttemptionsTimeout, TDuration::Max());
    R_READONLY(TDuration, FinishAttemptionsPause, TDuration::Seconds(5));
    R_READONLY(TSet<TString>, BlockedProcesses);
    R_READONLY(TPropositionsManagerConfig, PropositionsConfig);

public:
    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;
};
