#pragma once

#include <drive/backend/rt_background/common/config.h>

#include <drive/library/cpp/taxi/driver_profiles/client.h>
#include <drive/library/cpp/taxi/driver_status/client.h>
#include <drive/library/cpp/taxi/fleet_vehicles/client.h>

#include <rtline/library/unistat/signals.h>

class TBeginEndTaxiSessionsProcess: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;

    // TUnistatSignal<double> ErrorStartTaxiSessionsSignal;
    // TUnistatSignal<double> ErrorClosedTaxiSessionsSignal;
    // TUnistatSignal<double> SuccessStartTaxiSessionsSignal;
    // TUnistatSignal<double> SuccessClosedTaxiSessionsSignal;
    // TUnistatSignal<double> ExceptionStartTaxiSessionsSignal;
    // TUnistatSignal<double> ExceptionClosedTaxiSessionsSignal;

    struct TDriverCar {
        TString DriverId;
        TTaxiDriverStatusClient::EStatus DriverStatus;

    public:
        TString GetTaxiUserId() const {
            return DriverId + UserTaxiSuffix;
        }

        TString GetOrCreateUserId(const auto& server) const {
            auto userId = server.GetOrCreateUserId(GetTaxiUserId(), "taxi_session");
            return userId ? *userId : "";
        }
        bool MatchTaxiUser(const TString& sessionOwner, const auto& server) const {
            if (GetOrCreateUserId(server) == sessionOwner) {
                return true;
            }
            return false;
        }
    };

    NThreading::TFuture<TTaxiDriverStatusClient::TRecognizeStatuses> DoRequests(TTaxiFleetVehiclesClient::TRequestParams&& params, auto& eventLogState
        , auto& TaxiFleetVehiclesClient, auto& TaxiDriverProfilesClient, auto& TaxiDriverStatusClient, auto& parkIdCarIdToCarNumber
        , auto& parkIdDriverIdToCarNumber, auto& driverIdToFullName) const;

    bool CloseSession(auto& session, const auto& userId, const auto& server, const auto& carId) const;
    bool StartSession(const TDriverCar& driverCar, const auto& server, const auto& carId, const auto& driverIdToFullName) const;
    bool CheckAndLinkRole(const auto& userId, const auto& server) const;
    bool CheckDescriptionCompanyTag(const auto& userId, const auto& owningCarTagName, const auto& taxiCompanyDispayName, const auto& server) const;
    bool CheckAndAddOrganizationTag(const auto& userId, const auto& carId, const auto& server) const;
    bool ActualizeFullName(const TTaxiDriverProfilesClient::TRecognizedData& fullName, const auto& userId,  const auto& server) const;

public:
    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "start_close_taxi_session";
    }

    TBeginEndTaxiSessionsProcess()
        : TBase()
        // , ErrorStartTaxiSessionsSignal({"start-close-taxi-session-signal-error-start"}, false)
        // , ErrorClosedTaxiSessionsSignal({"start-close-taxi-session-signal-error-close"}, false)
        // , SuccessStartTaxiSessionsSignal({"start-close-taxi-session-signal-success-start"}, false)
        // , SuccessClosedTaxiSessionsSignal({"start-close-taxi-session-signal-success--close"}, false)
        // , ExceptionStartTaxiSessionsSignal({"start-close-taxi-session-signal-exception-start"}, false)
        // , ExceptionClosedTaxiSessionsSignal({"start-close-taxi-session-signal-exception-close"}, false)
    {
    }

    enum class EAffiliationOrganizationTagPolicy {
        Nothing /* "do_nothing" */,
        Update /* "only_update" */,
        All /* "add_and_update" */,
    };

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& value) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

private:
    bool DryRun = true;
    bool UpdateTaxiFullName = true;
    TString NeededUserRole = "engine_session_creator";
    const TString UserAffiliationOrganizationTagNamePrefix = "user_organization_affiliation_";
    TDuration WaitForTaxiApi = TDuration::Seconds(10);
    mutable ui32 BatchSize = 100;
    mutable ui32 RPSLimit = 10;
    static inline TString UserTaxiSuffix = "-taxi-user";

    EAffiliationOrganizationTagPolicy AffiliationOrganizationTagPolicy{EAffiliationOrganizationTagPolicy::Nothing};

    static TFactory::TRegistrator<TBeginEndTaxiSessionsProcess> Registrator;
};
