#pragma once

#include <drive/backend/rt_background/common/state.h>
#include <drive/backend/rt_background/manager/settings.h>

#include <drive/backend/proto/background.pb.h>



class TRTOrdersExportState : public TRTHistoryWatcherState {
    static TFactory::TRegistrator<TRTOrdersExportState> Registrator;
protected:
    virtual TString GetType() const;
};

class TRTOrdersExport: public IRTRegularBackgroundProcess {
    R_READONLY(ui64, StartFromId, 0);
    R_READONLY(TString, YTCluster);
    R_READONLY(TString, YTDir);
    R_READONLY(ui64, MaxCount, 1000);
    R_READONLY(TDuration, TimeDelay, TDuration::Minutes(1));
    R_READONLY(ui32, MdsRetries, 5);

private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TRTOrdersExport> Registrator;

public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "rt_orders_export";
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
};
