#pragma once

#include <drive/backend/rt_background/common/config.h>

#include <drive/backend/background/manager/regular.h>
#include <drive/backend/cars/hardware.h>
#include <drive/backend/data/device_tags.h>


class TRTInsuranceDateWatcherProcess : public IRTCarsProcess {
private:
    using TBase = IRTCarsProcess;
    R_READONLY(TString, NotifierName);
    R_READONLY(TDuration, PeriodCheck, TDuration::Days(14));
    R_READONLY(bool, AutoApprove, false);
    R_READONLY(TString, InsuranceTag);
    R_READONLY(TSet<TString>, TagsFilter);
    R_READONLY(TNeedInsuranceUpdateTag::EProvider, Provider);
    static TFactory::TRegistrator<TRTInsuranceDateWatcherProcess> Registrator;
protected:
    virtual TExpectedState DoExecuteFiltered(TAtomicSharedPtr<IRTBackgroundProcessState> /*state*/, const NDrive::IServer& server, TTagsModificationContext& context) const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    using TBase::TBase;

    static TString GetTypeName() {
        return "insurance_date_watcher";
    }
};

struct TInsuranceProcessError {
    TString Message;
    bool Critical;
    TString RequestError;

    TInsuranceProcessError(const TString& message, const bool critical = false, const TString& requestError = "")
        : Message(message)
        , Critical(critical)
        , RequestError(requestError)
        {
        }
};

struct TOrderInfo {
    bool Completed;
    TString Info;
    TOrderInfo(const bool completed, const TString& info)
        : Completed(completed)
        , Info(info)
        {
        }
};

class TRTInsuranceOrderStarterProcess : public IRTCarsProcess {
private:
    using TBase = IRTCarsProcess;
    R_READONLY(TString, NotifierName);
    R_READONLY(TString, WaitingOrderTag);
    R_READONLY(TString, WaitingUpdateTag);
    R_READONLY(TString, InsuranceTag);
    R_READONLY(TString, InsuranceOrderErrorTag);
    static TFactory::TRegistrator<TRTInsuranceOrderStarterProcess> Registrator;


    TExpected<TOrderInfo, TInsuranceProcessError> RequestForOrder(const NDrive::IServer& server, const TDBTag& dbTag, const TInstant startProcess) const;
    bool AddTag(const NDrive::IServer& server, const TDBTag& insuranceTag, const TString& tagName, const TString& carVin, NDrive::TEntitySession& session, TVector<TString>& carErrors, const TString updateInfo = "") const;
protected:
    virtual TExpectedState DoExecuteFiltered(TAtomicSharedPtr<IRTBackgroundProcessState> /*state*/, const NDrive::IServer& server, TTagsModificationContext& context) const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    using TBase::TBase;

    static TString GetTypeName() {
        return "insurance_order_starter";
    }
};

class TRTInsuranceUploaderProcess : public IRTCarsProcess {
private:
    using TBase = IRTCarsProcess;
    R_READONLY(TString, NotifierName);
    R_READONLY(TDuration, UpdatePeriod, TDuration::Hours(1));
    R_READONLY(TString, WaitingUpdateTag);
    R_READONLY(TString, InsuranceUpdateErrorTag);
    R_READONLY(TString, MdsBucket, "carsharing-car-documents");
    static TFactory::TRegistrator<TRTInsuranceUploaderProcess> Registrator;


    TMaybe<TInsuranceProcessError> RequestForUpdate(const NDrive::IServer& server, const TS3Client::TBucket* mdsBucket, const TDBTag& dbTag, const TInstant startProcess, const TString& /*updateData*/) const;
protected:
    virtual TExpectedState DoExecuteFiltered(TAtomicSharedPtr<IRTBackgroundProcessState> /*state*/, const NDrive::IServer& server, TTagsModificationContext& context) const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    using TBase::TBase;

    static TString GetTypeName() {
        return "insurance_uploader";
    }
};

class TRTInsuranceOrderWatcherProcess : public IRTCarsProcess {
private:
    using TBase = IRTCarsProcess;
    R_READONLY(TString, NotifierName);
    R_READONLY(TString, WaitingUpdateTag);
    R_READONLY(TString, InsuranceUpdateErrorTag);
    static TFactory::TRegistrator<TRTInsuranceOrderWatcherProcess> Registrator;


    TMaybe<TInsuranceProcessError> RequestToCheckUpdate(const NDrive::IServer& server, const TDBTag& dbTag, const TInstant startProcess) const;
protected:
    virtual TExpectedState DoExecuteFiltered(TAtomicSharedPtr<IRTBackgroundProcessState> /*state*/, const NDrive::IServer& server, TTagsModificationContext& context) const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    using TBase::TBase;

    static TString GetTypeName() {
        return "insurance_order_watcher";
    }
};
