#pragma once

#include <drive/backend/rt_background/common/config.h>

class TParkingPaymentMarkerWatcher: public IRTCarsProcess {
private:
    using TBase = IRTCarsProcess;

public:
    using TBase::TBase;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "parking_payment_marker_watcher";
    }

    virtual TExpectedState DoExecuteFiltered(TAtomicSharedPtr<IRTBackgroundProcessState> state, const NDrive::IServer& server, TTagsModificationContext& context) const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& value) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

private:
    TString TagName;
    double CostThreshold = 200;

private:
    static TFactory::TRegistrator<TParkingPaymentMarkerWatcher> Registrator;
};
