#pragma once

#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/rt_background/common/database.h>

#include <drive/backend/background/manager/regular.h>
#include <drive/backend/cars/hardware.h>
#include <drive/backend/data/device_tags.h>
#include <drive/backend/partners/common.h>


class TRTLeadsDataDistributeState : public TRTHistoryWatcherState {
    static TFactory::TRegistrator<TRTLeadsDataDistributeState> Registrator;
protected:
    virtual TString GetType() const;
};

class TRTLeadsDataDistributer : public IRTCarsProcess {
private:
    using TBase = IRTCarsProcess;
    static TFactory::TRegistrator<TRTLeadsDataDistributer> Registrator;

protected:
    using TBase::TBase;

    virtual TExpectedState DoExecuteFiltered(TAtomicSharedPtr<IRTBackgroundProcessState> state, const NDrive::IServer& server, TTagsModificationContext& context) const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
    virtual TString GetType() const override;

public:
    static TString GetTypeName() {
        return "leads_data_distributer";
    }

private:
    R_READONLY(TInstant, Since, TInstant::Zero());
    R_READONLY(NDrive::NPartners::EAggregator, Receiver);
    R_READONLY(TString, AllowTag);
    R_READONLY(ui32, SessionsLimit, 100);
    R_READONLY(ui32, LeadsPerRequest, 10);
    R_READONLY(TString, ClientConfig);

    NDrive::NPartners::ILeadsSender::TPtr Client;
};
