#pragma once

#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/tags/tag.h>

#include <rtline/library/geometry/coord.h>

class TRadarUserTagProcess: public IRTRegularBackgroundProcess {
    struct TCarInfo {
        TString Id;
        TGeoCoord Coord;
    };

private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TRadarUserTagProcess> Registrator;
    // FindBBoxCars finds cars by radarTag search area.
    //
    // TODO(iudovin@): Add filter by filters.
    static TVector<TCarInfo> FindBBoxCars(const NDrive::IServer& server, const TDBTag& radarTag);

public:
    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& value) override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "radar_user_tag_process";
    }

private:
    static TMaybe<bool> ApplyRadarTagByCar(const NDrive::IServer& server, const TUserPermissions::TConstPtr permissions, TDBTag& dbTag, const TString& carId, NDrive::TEntitySession& tx);

    static TMaybe<bool> ApplyRadarTag(const NDrive::IServer& server, const TUserPermissions::TConstPtr permissions, TDBTag& dbTag, NDrive::TEntitySession& tx);
};
