#pragma once

#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/rt_background/manager/manager.h>

#include <drive/backend/database/drive_api.h>
#include <drive/backend/documents_verification/manager.h>
#include <drive/backend/registrar/ifaces.h>

#include <drive/library/cpp/scheme/scheme.h>

class TRegistratorMaintenance: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;

public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    static TString GetTypeName() {
        return "user_registration_maintenance";
    }

    virtual TString GetType() const override {
        return GetTypeName();
    }

private:
    static TFactory::TRegistrator<TRegistratorMaintenance> Registrator;
};

class TRegistratorRegular: public IRTRegularBackgroundProcess {
private:
    TString NotifierName;

private:
    using TBase = IRTRegularBackgroundProcess;

private:
    static TFactory::TRegistrator<TRegistratorRegular> Registrator;

public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    static TString GetTypeName() {
        return "user_registration_manager";
    }

    virtual TString GetType() const override {
        return GetTypeName();
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual NJson::TJsonValue DoSerializeToJson() const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
};
