#pragma once

#include "unistat.h"

#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/rt_background/manager/manager.h>

#include <drive/backend/database/drive_api.h>
#include <drive/backend/documents_verification/manager.h>
#include <drive/backend/registrar/ifaces.h>

#include <drive/library/cpp/scheme/scheme.h>

class TRegistrationMonitoring: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;

    static TFactory::TRegistrator<TRegistrationMonitoring> Registrator;

    THolder<TDocumentsVerificationStateSignal> InitialAssignmentsSignal;
    THolder<TDocumentsVerificationStateSignal> RobotReaskSignal;
    THolder<TDocumentsVerificationStateSignal> AnalyticsReaskSignal;
    THolder<TDocumentsVerificationStateSignal> OtherReaskSignal;

    bool GetActiveTags(const TVector<TString>& tagNames, const NDrive::IServer* server, TVector<TDBTag>& dbTags) const;
    ui32 CountAndCleanup(const TVector<TString>& tagNames, const NDrive::IServer* server, TSet<TString>& observedUsers) const;

public:
    using TBase::TBase;

    TRegistrationMonitoring()
        : TBase()
    {
        InitialAssignmentsSignal.Reset(new TDocumentsVerificationStateSignal("initial"));
        RobotReaskSignal.Reset(new TDocumentsVerificationStateSignal("robot_reask"));
        AnalyticsReaskSignal.Reset(new TDocumentsVerificationStateSignal("analytics_reask"));
        OtherReaskSignal.Reset(new TDocumentsVerificationStateSignal("other_reask"));
    }

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    static TString GetTypeName() {
        return "registration_monitoring";
    }

    virtual TString GetType() const override {
        return GetTypeName();
    }
};
