#pragma once
#include <drive/backend/rt_background/common/config.h>

#include <drive/backend/background/manager/regular.h>
#include <drive/backend/proto/background.pb.h>

#include <rtline/util/types/accessor.h>

class TRegularPhotoReportWatcherState : public IProtoStateSerializable<NDrive::NProto::TCleaningReport> {
private:
    using TBase = IProtoStateSerializable<NDrive::NProto::TCleaningReport>;
    R_FIELD(ui64, LastEventId, 0);
    R_FIELD(ui64, LastSuccessfulTaskId, 0);

protected:
    virtual void SerializeToProto(NDrive::NProto::TCleaningReport& proto) const override;
    virtual bool DeserializeFromProto(const NDrive::NProto::TCleaningReport& proto) override;

public:
    using TBase::TBase;

    virtual NJson::TJsonValue GetReport() const override;
    virtual NDrive::TScheme DoGetScheme() const override;
    TString GetType() const override;

    static TFactory::TRegistrator<TRegularPhotoReportWatcherState> Registrator;
};

class TRegularPhotoReportWatcher : public IRTCarsProcess {
private:
    using TBase = IRTCarsProcess;
    R_READONLY(TString, NotifierName);
    R_READONLY(TSet<TString>, Tags, {});
    R_READONLY(TSet<TString>, Roles, {});
    R_READONLY(TSet<TString>, Departments);
    R_READONLY(ui64, StartEventId, 0);
    R_READONLY(ui64, StartIndex, 0);
    R_READONLY(TString, BucketName);
    R_READONLY(ui32, MaxSessionsCount, 30);
    R_READONLY(TDuration, PhotoDelay, TDuration::Minutes(15));

private:
    static TFactory::TRegistrator<TRegularPhotoReportWatcher> Registrator;
protected:
    virtual TExpectedState DoExecuteFiltered(TAtomicSharedPtr<IRTBackgroundProcessState> state, const NDrive::IServer& server, TTagsModificationContext& context) const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
public:
    virtual TString GetType() const override {
        return GetTypeName();
    }

    using TBase::TBase;

    static TString GetTypeName() {
        return "regular_photo_report";
    }
};
