#pragma once

#include <drive/backend/rt_background/manager/settings.h>

#include <drive/backend/cars/hardware.h>
#include <drive/backend/database/drive_api.h>

#include <rtline/util/types/accessor.h>

class TRTInsuranceMessagesWatcher: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;

private:
    static TFactory::TRegistrator<TRTInsuranceMessagesWatcher> Registrator;

public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "renins_export";
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

private:
    R_FIELD(TDuration, RequestTimeout, TDuration::Seconds(1));
    R_FIELD(ui32, RequestsAtOnce, 1);
    R_FIELD(ui32, MaxPackSize, 2000);
    R_FIELD(bool, PackMode, false);
    R_FIELD(bool, WithBaseCost, true);
    R_FIELD(bool, SkipEmpty, false);
    R_FIELD(NDrive::EInsuranceProvider, ProviderType, NDrive::EInsuranceProvider::Renins);
    R_READONLY(TString, NotifierName);
};
