#pragma once

#include <drive/backend/rt_background/manager/settings.h>
#include <drive/backend/rt_background/manager/state.h>

#include <drive/backend/car_attachments/documents/insurance.h>
#include <drive/backend/proto/background.pb.h>

#include <rtline/util/types/accessor.h>

class TRTInsuranceBuildesState: public IProtoStateSerializable<NDrive::NProto::THistoryProcessorData> {
private:
    using TBase = IProtoStateSerializable<NDrive::NProto::THistoryProcessorData>;

private:
    R_FIELD(ui64, LastEventId, Max<ui64>());
    R_FIELD(TString, LastError);

private:
    static TFactory::TRegistrator<TRTInsuranceBuildesState> Registrator;

protected:
    virtual void SerializeToProto(NDrive::NProto::THistoryProcessorData& proto) const override;
    virtual bool DeserializeFromProto(const NDrive::NProto::THistoryProcessorData& proto) override;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "insurance_tasks_builder";
    }

    virtual NJson::TJsonValue GetReport() const override {
        NJson::TJsonValue result = TBase::GetReport();
        JWRITE(result, "last_event_id", LastEventId);
        JWRITE(result, "last_error", LastError);
        return result;
    }

    virtual NDrive::TScheme DoGetScheme() const override {
        NDrive::TScheme result = TBase::DoGetScheme();
        result.Add<TFSNumeric>("last_event_id");
        result.Add<TFSString>("last_error");
        return result;
    }

    TString GetType() const override;
};

class TRTInsuranceTasksWatcher: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;
    using TTimetable = TTimeRestrictionsPool<TTimeRestriction>;

private:
    static TFactory::TRegistrator<TRTInsuranceTasksWatcher> Registrator;

public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "insurance_tasks_builder";
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

private:
    R_FIELD(TSet<NDrive::EInsuranceProvider>, AlwaysNonEmptyProviders);
    R_FIELD(TDuration, ZeroSpeedInterval, TDuration::Minutes(5));
    R_FIELD(TDuration, FaultsInterval, TDuration::Seconds(30));
    R_FIELD(TString, NotifierName);
    R_FIELD(TDuration, TrackApiTimeout, TDuration::Seconds(1));
    R_FIELD(TString, TrackApiName);
    R_FIELD(TString, SecondaryTrackApiName);
    R_FIELD(TTimetable, SplitTimetable);
    R_FIELD(bool, AlwaysCutEdges, false);
    R_FIELD(bool, DryRun, true);
    R_FIELD(ui64, StartEventId, 0);
    R_FIELD(ui64, MaxProcessingCount, 50000);
    R_FIELD(bool, SkipEmpty, false);
};
