#pragma once

#include <rtline/library/unistat/signals.h>

#include <drive/backend/rt_background/common/config.h>

class TStartRentalProcess: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;

public:
    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "start_rental";
    }

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;
    static void Execute(const NDrive::IServer& server, const TString& userId, TDuration threshold);
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& value) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

private:
    TDuration StartRentalTimeout = TDuration::Minutes(30);

private:
    static TFactory::TRegistrator<TStartRentalProcess> Registrator;
};
