#include "config.h"

#include <drive/backend/database/drive_api.h>
#include <drive/backend/device_snapshot/manager.h>
#include <drive/backend/surge/surge_snapshot.h>

#include <drive/library/cpp/scheme/scheme.h>

TRTCarFactors::TFactory::TRegistrator<TRTCarFactors> TRTCarFactors::Registrator("rt_car_factors");

TExpectedState TRTCarFactors::DoExecuteFiltered(TAtomicSharedPtr<IRTBackgroundProcessState> /*state*/, const NDrive::IServer& server, TTagsModificationContext& context) const {
    Y_UNUSED(context);
    if (!server.GetSurgeConstructor()) {
        ERROR_LOG << "Surge construction is disabled: !server->GetUsersController() || !server->GetSurgeConstructor()" << Endl;
        return new IRTBackgroundProcessState();
    }

    const TInstant start = Now();
    if (!server.GetSurgeConstructor()->BuildSurge()) {
        ERROR_LOG << "BuildSurge FAILED" << Endl;
    } else {
        INFO_LOG << (Now() - start) << " duration of BuildSurge method" << Endl;
    }
    return new IRTBackgroundProcessState();
}

NDrive::TScheme TRTCarFactors::DoGetScheme(const IServerBase& server) const {
    NDrive::TScheme scheme = TBase::DoGetScheme(server);
    scheme.Add<TFSDuration>("effective_duration", "Расстояние взаимодействия машина/пользователь для построения surge").SetDefault(TDuration::Minutes(25));
    return scheme;
}
