#pragma once

#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/rt_background/manager/manager.h>

#include <drive/backend/tags/tags_filter.h>

#include <drive/library/cpp/scheme/scheme.h>

class TRTCarFactors: public IRTCarsProcess {
private:
    using TBase = IRTCarsProcess;

private:
    static TFactory::TRegistrator<TRTCarFactors> Registrator;

public:
    virtual TString GetType() const override {
        return "rt_car_factors";
    }

    using TBase::TBase;

    virtual TExpectedState DoExecuteFiltered(TAtomicSharedPtr<IRTBackgroundProcessState> state, const NDrive::IServer& server, TTagsModificationContext& context) const override;

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
};
