#pragma once

#include <drive/backend/rt_background/common/state.h>
#include <drive/backend/rt_background/manager/settings.h>

#include <drive/backend/billing/exports/yt_nodes.h>

#include <rtline/library/time_restriction/time_restriction.h>
#include <rtline/util/types/accessor.h>


class TRTFuelingSalaryState : public TRTHistoryWatcherState {
    static TFactory::TRegistrator<TRTFuelingSalaryState> Registrator;
public:
    virtual TString GetType() const override;
};

class TRTFuelingSalaryWatcher: public IRTRegularBackgroundProcess, public NBillingExports::ISalaryExportContext {
private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TRTFuelingSalaryWatcher> Registrator;

public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "salary_watcher";
    }

    virtual const TString& GetBalanceServiceID() const override {
        return ServiceID;
    }
    virtual const TString& GetBalancePaymentType() const override {
        return PaymentType;
    }
    virtual const TString& GetBalancePartnerID() const override {
        return PartnerID;
    }
    virtual const TString& GetBalanceProduct() const override {
        return Product;
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

private:
    TSet<TString> SalaryTags;
    R_FIELD(TString, YTCluster);
    R_FIELD(TString, YTDir);
    R_FIELD(TString, NotifierName);
    R_FIELD(TString, Product, "fake");
    R_FIELD(TString, ServiceID, "fake");
    R_FIELD(TString, PartnerID, "fake");
    R_FIELD(TString, PaymentType, "fake");
    R_FIELD(TInstant, FirstInstant, TInstant::Zero());
};
