#pragma once

#include <drive/backend/rt_background/common/config.h>


class TSensorsHelper {
public:
    using TOptCarValues = TMaybe<TMap<TString, double>>;

private:
    R_READONLY(ui32, SensorId, 0);
    R_READONLY(ui32, SensorSubId, 0);

public:
    void PatchScheme(NDrive::TScheme& scheme) const;
    bool DeserializeFromJson(const NJson::TJsonValue& json);
    void PatchJson(NJson::TJsonValue& json) const;
    TOptCarValues GetSensorValues(const IRTCarsProcess::TTagsModificationContext& context, const bool useSensorApi, const TDuration freshness, const TInstant startTS) const;
};

class TNotifyHelper {
private:
    R_READONLY(TString, NotifierName);
    R_READONLY(bool, ReportCarsList, true);
    R_FIELD(TString, DefaultNotifyHeader);

public:
    void PatchScheme(const IServerBase& server, NDrive::TScheme& scheme) const;
    bool DeserializeFromJson(const NJson::TJsonValue& json);
    void PatchJson(NJson::TJsonValue& json) const;
    void Notify(const NDrive::IServer& server, const TVector<TString>& lines, const TString& header = "", const bool force = false) const;
};
