#pragma once

#include "common.h"


class TRTMaintenanceWatcher: public IRTCarsProcess {
private:
    using TBase = IRTCarsProcess;

public:
    virtual TString GetType() const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

    static TString GetTypeName();

protected:
    virtual TExpectedState DoExecuteFiltered(TAtomicSharedPtr<IRTBackgroundProcessState> state, const NDrive::IServer& server, TTagsModificationContext& context) const override;
    virtual bool DoStart(const TRTBackgroundProcessContainer& container) override;

private:
    R_READONLY(TString, Tag);
    R_READONLY(ui64, CriticalValue, 0);
    R_READONLY(ui16, Priority, 0);
    R_READONLY(ui32, Precision, 0);
    R_READONLY(TDuration, CriticalPeriod, TDuration::Zero());
    R_READONLY(bool, RemoveTags, false);
    R_READONLY(bool, DryRunMode, false);
    R_READONLY(bool, ModifyPerformed, true);
    R_READONLY(ui32, BlocksCountLimit, 0);
    R_READONLY(TDuration, SensorFreshness, TDuration::Minutes(1));
    R_FIELD(TSensorsHelper, SensorHelper);
    R_FIELD(TNotifyHelper, NotifyHelper);

    static TFactory::TRegistrator<TRTMaintenanceWatcher> Registrator;
};
