#pragma once

#include "common.h"

#include <drive/backend/rt_background/manager/settings.h>

#include <drive/backend/data/user_tags.h>
#include <drive/telematics/server/location/location.h>

namespace NServiceRouting {

    NJson::TJsonValue SerializeRoutingOptionsToJson(const TGeneralOptions& generalOptions, const TRoutingOptions& routingOptions);
    TExpected<TRoutingTask, TEnqueueError> EnqueueRoutingTask(const TVector<TUserInfo>& usersInfos, const TVector<TServiceTaskInfo>& serviceTasksInfos,
                                                              const TGeneralOptions& generalOptions, const TRoutingOptions& routingOptions, TDuration timeout);

    // Get current day YYYY-MM-DD
    TString GetCurrentDay(TInstant timestamp, const int timezone);

    TMaybe<std::pair<TInstant, TInstant>> GetActualShift(TInstant now, const TVector<TShiftDescription>& shifts);

    class TServiceRouteCalculatorProcess : public IRTRegularBackgroundProcess {
    private:
        using TBase = IRTRegularBackgroundProcess;

    public:
        static TString GetTypeName();

        virtual TString GetType() const override;
        virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;
        virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
        virtual bool DoDeserializeFromJson(const NJson::TJsonValue& value) override;
        virtual NJson::TJsonValue DoSerializeToJson() const override;

    private:
        TVector<TMaybe<NDrive::TLocation>> GetWorkersCarsPositions(const TExecutionContext& context, const TVector<TUserId>& workersIds) const;
        TVector<TMaybe<TGeoCoord>> GetWorkersPositions(const TExecutionContext& context, const TVector<TUserId>& workersIds) const;
        void AssignServiceTasks(const TExecutionContext& context, const TMap<TUserId, TServiceRoute>& routes) const;
        TVector<TUserInfo> FetchActiveWorkers(const TExecutionContext& context) const;
        TVector<TServiceTaskInfo> FetchTasks(const TExecutionContext& context, const TVector<TUserInfo>& activeWorkersInfos, const TGeneralOptions& generalOptions) const;
        TDuration GetServiceTaskDurationByTagName() const;
        TMap<TUserId, TInstant> UpdateAdditionalTagNamesState(TInstant now, TMap<TString, TInstant> lastSetAdditionalTagNames, const NDrive::IServer& server) const;
        void UpdateCarsRelationsToRouting(const NDrive::IServer& server, const TSet<TString>& carsInRoutingIds, NDrive::TEntitySession& session) const;

    private:
        static const TString AvailableZonesTagNameSettings;
        static TFactory::TRegistrator<TServiceRouteCalculatorProcess> Registrator;

    private:
        TDuration RoutesRecalculationPeriod;
        TDuration WorkerActivenessThreshold;
        TDuration EnqueueHandlerTimeout = TDuration::Seconds(10);
        bool CheckWorkerActiveness = false;
        TSet<TString> ServiceWorkersRolesNames;
        TSet<TString> ForbiddenCarTagsNames;
        TSet<TString> ExcludedAreas;
        TVector<TShiftDescription> Shifts;
        bool UseUtilizedZonesOnly = false;
        TRoutingOptions RoutingOptions;
        TMaybe<TDuration> RoutingTaskMaxAge;
        bool FixPerformerTasks = false;
        TMaybe<TDuration> AdditionalTagNamesLifetime;
        bool EmptyNonUsedWorkersRouteTags = false;
        bool MarkCarsInRouting = false;
    };
};
