#include "state.h"

#include <rtline/library/json/cast.h>

namespace NServiceRouting {
    TServiceRouteCalculatorProcessState::TFactory::TRegistrator<TServiceRouteCalculatorProcessState> TServiceRouteCalculatorProcessState::Registrator(TServiceRouteCalculatorProcessState::GetTypeName());

    TString TServiceRouteCalculatorProcessState::GetTypeName() {
        return "service_route_calculator";
    }

    TString TServiceRouteCalculatorProcessState::GetType() const {
        return GetTypeName();
    }

    NJson::TJsonValue TServiceRouteCalculatorProcessState::SerializeToJson() const {
        NJson::TJsonValue result;
        result["executing_tasks"] = NJson::ToJson(ExecutingTasks);
        result["last_routes_calculation_time"] = LastRoutesCalculationTime.Seconds();
        result["last_set_additional_tags"] = NJson::ToJson(LastSetAdditionalTags);
        return result;
    }

    bool TServiceRouteCalculatorProcessState::DeserializeFromJson(const NJson::TJsonValue& value) {
        return NJson::ParseField(value["executing_tasks"], ExecutingTasks)
            && NJson::ParseField(value["last_set_additional_tags"], LastSetAdditionalTags)
            && NJson::ParseField(value["last_routes_calculation_time"], LastRoutesCalculationTime);
    }
};
