#pragma once
#include "common.h"

#include <drive/backend/rt_background/manager/state.h>

#include <library/cpp/json/json_reader.h>

namespace NServiceRouting {
    class TServiceRouteCalculatorProcessState : public TJsonRTBackgroundProcessState {
    public:
        static TString GetTypeName();
        virtual TString GetType() const override;

    protected:
        virtual NJson::TJsonValue SerializeToJson() const override;
        virtual bool DeserializeFromJson(const NJson::TJsonValue& value) override;

    private:
        using TLastSetAdditionalTags = TMap<TUserId, TInstant>;

    private:
        static TFactory::TRegistrator<TServiceRouteCalculatorProcessState> Registrator;
        R_FIELD(TVector<TRoutingTask>, ExecutingTasks);
        R_FIELD(TInstant, LastRoutesCalculationTime);
        R_FIELD(TLastSetAdditionalTags, LastSetAdditionalTags);
    };
};
