#pragma once

#include <drive/backend/rt_background/common/config.h>

class TCloseSignalqSessionsProcess: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;

public:
    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "close_signalq_session";
    }

    TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;
    NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    bool DoDeserializeFromJson(const NJson::TJsonValue& value) override;
    NJson::TJsonValue DoSerializeToJson() const override;

private:
    bool DryRun = true;
    TDuration SignalqSessionsStatusTimeout = TDuration::Minutes(30);
    TDuration SignalqSessionsEventTimeout;

    static TFactory::TRegistrator<TCloseSignalqSessionsProcess> Registrator;
};
