#pragma once

#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/rt_background/common/state.h>

class TRTSignalqEventsSupportNotificationState : public TRTHistoryWatcherState {
    static TFactory::TRegistrator<TRTSignalqEventsSupportNotificationState> Registrator;
public:
    TString GetType() const override;
};

class TRTSignalqEventsSupportNotification: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;

public:
    TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "signalq_events_support_notification";
    }

    TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> stateExt, const TExecutionContext& context) const override;
    NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    bool DoDeserializeFromJson(const NJson::TJsonValue& value) override;
    NJson::TJsonValue DoSerializeToJson() const override;

private:
    bool DryRun = true;
    ui32 Limit = 300;
    TDuration MaxEventAtDelay = TDuration::Seconds(600);
    TVector<TString> CarTagNames;
    mutable TMap<TString, TSet<TString>> EventTypesToMediaTypes;
    TDuration MediaUrlTtl = TDuration::Days(1);
    bool NotifyAboutOnlyFullUploadedEvents = true;
    TString CarsharingBackendUri = "http://stable.carsharing.yandex.net";
    ui32 DriveTvmId = 2000615;

    static TFactory::TRegistrator<TRTSignalqEventsSupportNotification> Registrator;
};
