#pragma once

#include <drive/backend/rt_background/common/config.h>

class TSql2UnistatProcess
    : public IRTRegularBackgroundProcess
{
private:
    using TBase = IRTRegularBackgroundProcess;

public:
    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "sql2unistat";
    }

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& value) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

private:
    TString Query;
    TString DBName;

private:
    static TFactory::TRegistrator<TSql2UnistatProcess> Registrator;
};
