#pragma once

#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/rt_background/common/yt.h>

class TSql2YtProcess
    : public IRTRegularBackgroundProcess
    , public TYtProcessTraits
{
private:
    using TBase = IRTRegularBackgroundProcess;

public:
    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "sql2yt";
    }

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& value) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

private:
    TString GetTableName(TInstant now) const;

private:
    TSet<TString> StringFields;
    TDuration TimeToLive;
    TString Query;
    TString YtCluster;
    TString YtDirectory;
    TString DBName;
    bool CreateYtDirectory = false;

private:
    static TFactory::TRegistrator<TSql2YtProcess> Registrator;
};
