#pragma once

#include <drive/backend/data/user_tags.h>
#include <drive/backend/rt_background/common/config.h>

class TSubscriptionCheckProcess: public IRTRegularBackgroundProcess {

private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TSubscriptionCheckProcess> Registrator;

public:
    using TBase::TBase;
    TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "subscription_check_process";
    }

    NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    bool DoDeserializeFromJson(const NJson::TJsonValue& value) override;
    NJson::TJsonValue DoSerializeToJson() const override;


private:
    bool ProcessSubscriptionTag(TDBTag& dbTag, const NDrive::IServer& server) const;
    bool ProcessPendingTag(TDBTag& dbTag, TUserSubscriptionTag& tag, const NDrive::IServer& server, NDrive::TEntitySession& tx) const;
    bool ProcessActiveTag(TDBTag& dbTag, TUserSubscriptionTag& tag, const NDrive::IServer& server, NDrive::TEntitySession& tx) const;

    bool UpdateTag(TDBTag& dbTag, TUserSubscriptionTag& tag, const NDrive::IServer& server, NDrive::TEntitySession& tx) const;
    bool RemoveTag(TDBTag& dbTag, const NDrive::IServer& server, NDrive::TEntitySession& tx) const;
    bool ApplyPayment(TDBTag& dbTag, TUserSubscriptionTag& tag, const NDrive::IServer& server, NDrive::TEntitySession& tx) const;

    bool AddPushTagOnFailedPayment(const NDrive::IServer& server, NDrive::TEntitySession& tx, const TString& userId, const TString& pushTagName) const;

private:
    R_FIELD(TDuration, TimeShiftForPayment, TDuration::Hours(3));
    R_FIELD(TString, FailedPaymentPushTagName);
    R_FIELD(TString, FailedAutoRenevalPushTagName);
    R_FIELD(TString, ForbiddenPushTagName);
    mutable THashSet<TString> UsersWithForbiddenPush;
};
