#pragma once

#include <drive/library/cpp/threading/future.h>

namespace NDrive {
    template<class TFutureResult>
    class TFutureCallResults {
    private:
        using TFuture = NThreading::TFuture<TFutureResult>;
        using TFutures = TVector<TFuture>;

    private:
        TFutures Results;
        TVector<TString> ResultMap;

    public:
        void EmplaceResult(const TString& callId, TFuture&& result) {
            ResultMap.emplace_back(callId);
            Results.emplace_back(std::move(result));
        }

        TFutures& GetResults() {
            return Results;
        }

        TFuture* GetResultPtr(const ui32 ind) {
            return ind < Results.size() ? &Results[ind] : nullptr;
        }

        TString GetCallId(const ui32 ind) {
            return ind < ResultMap.size() ? ResultMap[ind] : "";
        }
    };
}
