#pragma once

#include "common.h"

#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/rt_background/common/state.h>
#include <drive/backend/rt_background/manager/manager.h>

#include <drive/backend/database/drive_api.h>
#include <drive/backend/support_center/manager.h>

#include <drive/library/cpp/scheme/scheme.h>


class TInternalCallCenterRecordsState : public TRTHistoryWatcherState {
public:
    virtual TString GetType() const override;

private:
    static TFactory::TRegistrator<TInternalCallCenterRecordsState> Registrator;
};

class TInternalCallCenterRecordsProcessor : public IRTRegularBackgroundProcess {
public:
    using TFutureResults = NDrive::TFutureCallResults<std::pair<NCallCenterYandex::EInternalCallProcessResult, TString>>;

private:
    R_FIELD(bool, NeedCheck, false);
    R_FIELD(ui32, MaxCallsCount, 1000);
    R_FIELD(ui32, MaxEventsCount, 5000);
    R_FIELD(ui32, CheckEventsCount, 2500);
    R_FIELD(ui32, MaxCallsInRequest, 5);
    R_FIELD(ui32, SkipErrorsCount, 5);
    R_FIELD(TDateTimeFilterConfig, TimeFilterConfig);
    R_FIELD(TString, BucketName);
    R_FIELD(ui32, RetryCount, 0);

private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TInternalCallCenterRecordsProcessor> Registrator;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "support_cipt_calls_loader";
    }

    virtual TString GetType() const override {
        return GetTypeName();
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    bool ProcessFutureResults(const ISupportCenterManager& manager, TFutureResults& results, TSet<TString>& callIds) const;
    bool ProcessCalls(const ISupportCenterManager& manager, const NS3::TBucket& bucket, TSet<TString>& callIds) const;
};
