#pragma once

#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/rt_background/manager/manager.h>

#include <drive/backend/database/drive_api.h>
#include <drive/backend/support_center/manager.h>

#include <drive/library/cpp/scheme/scheme.h>

class TSupportRequestsDistributor: public IRTRegularBackgroundProcess {
    TString NotifierName;
    TVector<TString> Tags;

private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TSupportRequestsDistributor> Registrator;

public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    static TString GetTypeName() {
        return "support_requests_distributor";
    }

    virtual TString GetType() const override {
        return GetTypeName();
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual NJson::TJsonValue DoSerializeToJson() const override;

    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
};

class TWebPhoneCallDataSyncProcessor : public IRTRegularBackgroundProcess {
    R_FIELD(ui32, MaxCallsCount, 1000);

private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TWebPhoneCallDataSyncProcessor> Registrator;

public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    static TString GetTypeName() {
        return "support_webphone_calls_sync";
    }

    virtual TString GetType() const override {
        return GetTypeName();
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual NJson::TJsonValue DoSerializeToJson() const override;

    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
};
