#pragma once

#include <drive/backend/abstract/frontend.h>
#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/rt_background/common/state.h>
#include <drive/backend/rt_background/manager/settings.h>
#include <drive/backend/rt_background/manager/state.h>

#include <drive/library/cpp/support_ai/client.h>


class TRTSupportAIProcessState : public TRTHistoryWatcherState {
    static TFactory::TRegistrator<TRTSupportAIProcessState> Registrator;
public:
    virtual TString GetType() const override;
};

class TRTSupportAIProcess: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;

private:
    R_READONLY(TInstant, Since, TInstant::Zero());
    R_READONLY(ui32, PackSize, 1000);
    R_FIELD(TVector<TString>, Tags);

    static TFactory::TRegistrator<TRTSupportAIProcess> Registrator;

public:
    using TBase::TBase;
    TString GetType() const override;
    NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    NJson::TJsonValue DoSerializeToJson() const override;
    bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    static TString GetTypeName();
};

class TRTSupportAISyncProcess: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;

private:
    R_READONLY(ui32, MaxCallsCount, 1000);
    R_FIELD(TDateTimeFilterConfig, TimeFilterConfig);
    R_FIELD(TString, BucketName);
    R_READONLY(ui32, MaxCallsInRequest, 5);

    static TFactory::TRegistrator<TRTSupportAISyncProcess> Registrator;

public:
    using TBase::TBase;
    TString GetType() const override;
    NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    NJson::TJsonValue DoSerializeToJson() const override;
    bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    static TString GetTypeName();
};
