#pragma once

#include <drive/backend/rt_background/common/config.h>

#include <library/cpp/charset/ci_string.h>

const TString TaxiColorBlack = "Черный";
const TString TaxiColorYellow = "Желтый";

class TTaxiFleetSyncProcess : public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;

public:
    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "taxi_fleet_sync";
    }

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& value) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

private:
    TString GetBrand(const TString& manufacturer) const;
    TString GetModel(const TString& shortName) const;
    ui64 GetYear(const TString& code) const;

    bool AddObjectIdToState(
        const TString& userId,
        const TString& objectId,
        const TString& previousCarId,
        const NDrive::IServer& server,
        NDrive::TEntitySession& session
    ) const;
    bool RemoveObjectIdFromState(
        const TString& userId,
        const TString& objectId,
        TString& previousObjectId,
        TString& previousCarId,
        const NDrive::IServer& server,
        NDrive::TEntitySession& session
    ) const;

private:
    TSet<TString> AllowedOfferConstructors;
    TSet<TString> Amenities;
    TSet<TString> Categories = {
        "business"
    };
    TMap<TCiString, TString> BrandRemap = {
        { "Mercedes", "Mercedes-Benz" },
    };
    TMap<TCiString, TString> ModelRemap = {
        { "E200", "E-klasse" },
        { "520i", "5er" },
    };
    TMap<TCiString, ui64> YearRemap = {
        { "bmw_520d_xDrive_restyling_2020", 2020 },
        { "bmw_520d_restyling_2020", 2020 },
        { "mercedes_e200_restyling_2020", 2021 },
        { "mercedes_e200d_restyling_2020", 2021 },
    };
    TString Color = TaxiColorBlack;
    TString Endpoint;
    TString AuthInfoTagName = "taxi_fleet_auth_info";
    TString StateTagName = "taxi_fleet_state";
    bool RestoreLinking = true;
    bool UseProductionYear = true;

private:
    static TFactory::TRegistrator<TTaxiFleetSyncProcess> Registrator;
};
