#pragma once

#include <drive/backend/rt_background/common/config.h>

#include <drive/backend/background/manager/regular.h>


class TRTTechDispatchWatcherProcess : public IRTCarsProcess {
private:
    using TBase = IRTCarsProcess;
    R_FIELD(TString, LimitTagName);
    static TFactory::TRegistrator<TRTTechDispatchWatcherProcess> Registrator;
protected:
    virtual TExpectedState DoExecuteFiltered(TAtomicSharedPtr<IRTBackgroundProcessState> /*state*/, const NDrive::IServer& server, TTagsModificationContext& context) const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    using TBase::TBase;

    static TString GetTypeName() {
        return "tech_dispatch_watcher";
    }
};
