#pragma once

#include <rtline/library/unistat/cache.h>

class TTollRoadLogger {
public:
    static void CantRetrieveEvents(const TString& road = "") {
        ERROR_LOG << "Toll road charges: can't retrieve events " << Endl;
        TUnistatSignalsCache::SignalAdd("toll-road" + road, "api_call_failed", 1);
    }

    static void PositiveOrZeroMoney(const TString& road = "") {
        TUnistatSignalsCache::SignalAdd("toll-road" + road, "positive_or_zero_money", 1);
    }

    static void CarNotFound(const TString& transponderId, const TString& road = "") {
        ERROR_LOG << "Toll road charges: car not found for transponder " << transponderId << Endl;
        TUnistatSignalsCache::SignalAdd("toll-road" + road, "car_not_found", 1);
    }

    static void CantInitSession(const TString& transponderId, const TString& carId, const TString& road = "") {
        ERROR_LOG << "Toll road charges: couldn't initialize session for " << transponderId << ", car id: " << carId << Endl;
        TUnistatSignalsCache::SignalAdd("toll-road" + road, "cant_init_session", 1);
    }

    static void TooManySessions(const TString& transponderId, const TString& carId, const TString& road = "") {
        ERROR_LOG << "Toll road charges: too many sessions found " << transponderId << ", car id: " << carId << Endl;
        TUnistatSignalsCache::SignalAdd("toll-road" + road, "too_many_sessions", 1);
    }

    static void SessionNotFound(const TString& transponderId, const TString& carId, const TString& road = "") {
        ERROR_LOG << "Toll road charges: session not found for transponder " << transponderId << ", car id: " << carId << Endl;
        TUnistatSignalsCache::SignalAdd("toll-road" + road, "session_not_found", 1);
    }

    static void WrongSession(const TString& transponderId, const TString& carId, const TString& sessionId, const TString& road = "") {
        ERROR_LOG << "Toll road charges: no riding in found session " << sessionId << ", transponder: " << transponderId << ", car id: " << carId << Endl;
        TUnistatSignalsCache::SignalAdd("toll-road" + road, "wrong_session", 1);
    }

    static void NoOfferBuilderAction(const TString& sessionId, const TString& road = "") {
        ERROR_LOG << "Toll road charges: couldn't get offer builder action for session " << sessionId << Endl;
        TUnistatSignalsCache::SignalAdd("toll-road" + road, "no_offer", 1);
    }

    static void NoOffer(const TString& sessionId, const TString& road = "") {
        ERROR_LOG << "Toll road charges: couldn't get offer for session " << sessionId << Endl;
        TUnistatSignalsCache::SignalAdd("toll-road" + road, "no_offer", 1);
    }

    static void FilteredOut(const TString& road = "") {
        TUnistatSignalsCache::SignalAdd("toll-road" + road, "filtered_out", 1);
    }

    static void FilteredOutRoadType(const TString& id, const TString& transponderId, const bool whsd, const bool intercity, const TString& road = "") {
        INFO_LOG << "Toll road charges: transponder " << transponderId << " with event id " << id << " filtered out as wrong typed. Include Whsd: " << whsd << ", intercity " << intercity << Endl;
        TUnistatSignalsCache::SignalAdd("toll-road" + road, "filtered_out_road_type", 1);
    }

    static void FilteredOutCarId(const TString& carId, const TString& road = "") {
        INFO_LOG << "Toll road charges: car_id filtered out " << carId << Endl;
        TUnistatSignalsCache::SignalAdd("toll-road" + road, "filtered_out_car_id", 1);
    }

    static void RequestStarted(const TString& road = "") {
        INFO_LOG << "Toll road charges: request started";
        TUnistatSignalsCache::SignalAdd("toll-road" + road, "request_started", 1);
    }

    static void FailedToAddTag(const TString& userId, const TString& carId, const TString& sessionId, const TString& messages, const TString& road = "") {
        ERROR_LOG << "Toll road charges: failed to add tag " << sessionId << ", user: " << userId << ", car id: " << carId << ". Report: " << messages << Endl;
        TUnistatSignalsCache::SignalAdd("toll-road" + road, "billing_failed", 1);
    }

    static void FailedToAddTags(const TString& messages, const TString& road = "") {
        ERROR_LOG << "Toll road charges: failed to commit tags. Report: " << messages << Endl;
        TUnistatSignalsCache::SignalAdd("toll-road" + road, "billing_failed", 1);
    }

    static void BillingTagAssigned(const ui32 count, const TString& road = "") {
        TUnistatSignalsCache::SignalAdd("toll-road" + road, "billing_assigned", count);
    }

    static void BillingCheckFailed(const TString& userId, const TString& road = "") {
        ERROR_LOG << "Toll road charges: failed to check if billing is allowed for user: " << userId << Endl;
        TUnistatSignalsCache::SignalAdd("toll-road" + road, "billing_check_failed", 1);
    }

    static void YTDumpFailed(const TString& table, const TString& cluster, const TString& exception, const TString& road = "") {
        ERROR_LOG << "Toll road charges: couldn't dump failed events to table " << table << ", cluster " << cluster << ". Error: " << exception << Endl;
        TUnistatSignalsCache::SignalAdd("toll-road" + road, "yt_dump_failed", 1);
    }

    static void YTDumpSkipped(const TString& table, const TString& cluster, const TString& road = "") {
        ERROR_LOG << "Toll road charges: table not configured " << table << ", cluster " << cluster << ". Road bot: " << road << Endl;
    }
};
