#pragma once

#include "road_config.h"

#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/rt_background/common/state.h>
#include <drive/backend/rt_background/manager/settings.h>

#include <drive/backend/history_iterator/history_iterator.h>

#include <drive/library/cpp/whsd/client.h>

#include <rtline/util/types/accessor.h>

class TRTRoadChargesWatcherState : public TRTInstantWatcherState {
    static TFactory::TRegistrator<TRTRoadChargesWatcherState> Registrator;
public:
    virtual TString GetType() const override;
};

class TRTRoadChargesWatcher : public IRTCarsProcess {
public:
    class TRoadInfo {
        R_READONLY(TAtomicSharedPtr<ITollRoad>, RoadType);
        R_READONLY(TAtomicSharedPtr<ITollRoadConfig>, RoadConfig);
        R_READONLY(TString, BillingAllowedSettingName);
        R_READONLY(TString, FreeRidesNumberSettingName);
        R_READONLY(TString, LandingDateTimeFormat, "%Y.%m.%d %H:%M:%S");
        R_READONLY(TVector<TString>, BillingTagNames);
        R_READONLY(TVector<TString>, BillingSkippedTagNames);
        R_READONLY(ui32, FreeRidesNumber, 1);
    public:
        TRoadInfo() = default;

        bool DeserializeFromJson(const NJson::TJsonValue& jsonInfo);
        NJson::TJsonValue SerializeToJson() const;
    };

    enum EContextParameterKey {
        EventTimestamp /* "event_timestamp" */,
        BillingAmount /* "billing_amount" */,
        TollRoadEntry /* "toll_road_entry" */,
        TollRoadExit /* "toll_road_exit" */
    };

    R_READONLY(TInstant, FirstInstant);
    R_READONLY(TInstant, LastInstant);
    R_READONLY(TDuration, Delay);
    R_READONLY(TDuration, MaxPeriod);
    R_READONLY(TString, YTTablePath);
    R_READONLY(TString, YTClusterName);
    R_READONLY(TVector<TRoadInfo>, RoadsInfo);
    R_READONLY(TTagsFilter, OfferAttributesFilter);
    R_READONLY(ui32, MinRideDistance, 0);
    R_READONLY(ui32, MaxSessionsToProcess, 100000);
    R_READONLY(TString, NotifierName);
    R_READONLY(TString, FailedEventsNotifierName);

private:
    using TBase = IRTCarsProcess;
    using TFailedEvent = std::pair<TTransponderEvent, TString>;
    static TFactory::TRegistrator<TRTRoadChargesWatcher> Registrator;

public:
    using TBase::TBase;

    virtual TExpectedState DoExecuteFiltered(TAtomicSharedPtr<IRTBackgroundProcessState> state, const NDrive::IServer& server, TTagsModificationContext& context) const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "road_charges_watcher";
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

private:
    bool AddBillingTags(const TVector<TTransponderEvent>& events, const NDrive::IServer& server) const;
    TVector<TTransponderEvent> FillSessionData(TVector<TTransponderEvent>& events, TVector<TFailedEvent>& failedEvents, const NDrive::IServer& server) const;
    TMaybe<TVector<THistoryRideObject>> GetHistoryRides(const TTransponderEvent& event, const NDrive::IServer& server) const;
    bool FillRidingData(TTransponderEvent& event, TVector<THistoryRideObject>& rides, const NDrive::IServer& server) const;
    bool CheckOfferAttributes(const TTransponderEvent& sessionInfo, const NDrive::IServer& server) const;
    IOffer::TPtr GetOffer(const TString& sessionId, const TSessionsBuilder<TCarTagHistoryEvent>::TPtr billingSessions) const;
    bool DumpFailedEvents(const TVector<TFailedEvent>& failedEvents, const NDrive::IServer& server) const;
    TMaybe<bool> CheckIfShouldBill(const TTransponderEvent& event, const NDrive::IServer& server, NDrive::TEntitySession& session) const;
private:
    mutable TVector<TAtomicSharedPtr<ITollRoadConfig>> RoadConfigs;
};
