#include "road_config.h"

TWhsdRoadConfig::TFactory::TRegistrator<TWhsdRoadConfig> TWhsdRoadConfig::Registrator(TWhsdRoad::GetTypeName());

bool TWhsdRoadConfig::DeserializeFromJson(const NJson::TJsonValue& jsonInfo) {
    if (!NJson::ParseField(jsonInfo, ClientConfigString, true)) {
        return false;
    }
    return ParseFromString(ClientConfigString);
}

NJson::TJsonValue TWhsdRoadConfig::SerializeToJson() const {
    return {ClientConfigString};
}

bool TWhsdRoadConfig::Init(const TYandexConfig::Section* section) {
    return ClientConfig.Init(section);
}

bool TWhsdRoadConfig::ParseFromString(const TString& configStr) {
    TAnyYandexConfig config;
    if (!config.ParseMemory(configStr.data())) {
        return false;
    }
    IncludeWhsd = config.GetRootSection()->GetDirectives().Value<bool>("IncludeWhsd", true);
    IncludeIntercity = config.GetRootSection()->GetDirectives().Value<bool>("IncludeIntercity", false);
    return Init(config.GetRootSection());
}

void TWhsdRoadConfig::ToString(IOutputStream& os) const {
    ClientConfig.ToString(os);
}

THolder<ITollRoad> TWhsdRoadConfig::Construct() const {
    return MakeHolder<TWhsdRoad>(ClientConfig, IncludeWhsd, IncludeIntercity);
}
