#pragma once

#include "road_type.h"

#include <drive/backend/abstract/base.h>

#include <drive/library/cpp/whsd/client.h>

#include <library/cpp/json/writer/json_value.h>
#include <library/cpp/object_factory/object_factory.h>
#include <library/cpp/yconf/conf.h>

#include <util/generic/ptr.h>

class ITollRoadConfig {
public:
    using TFactory = NObjectFactory::TParametrizedObjectFactory<ITollRoadConfig, TString>;

public:
    virtual ~ITollRoadConfig() = default;

    virtual bool Init(const TYandexConfig::Section* section) = 0;
    virtual void ToString(IOutputStream& os) const = 0;

    virtual bool DeserializeFromJson(const NJson::TJsonValue& jsonInfo) = 0;
    virtual NJson::TJsonValue SerializeToJson() const = 0;

    virtual THolder<ITollRoad> Construct() const = 0;
};

class TWhsdRoadConfig : public ITollRoadConfig {
private:
    static TFactory::TRegistrator<TWhsdRoadConfig> Registrator;

public:
    TWhsdRoadConfig() = default;

    virtual bool DeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue SerializeToJson() const override;

    virtual bool Init(const TYandexConfig::Section* section) override;
    virtual void ToString(IOutputStream& os) const override;

    virtual THolder<ITollRoad> Construct() const override;

private:
    bool ParseFromString(const TString& configStr);

private:
    TWhsdClientConfig ClientConfig;
    TString ClientConfigString;
    bool IncludeWhsd;
    bool IncludeIntercity;
};
