#pragma once

#include <drive/backend/rt_background/common/config.h>

class TAnalyzerCacheProcess: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;

public:
    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "analyzer_cache";
    }

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& value) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

private:
    TInstant GetRoundedTimestamp(TInstant timestamp) const;
    TString GetTableName(TInstant timestamp) const;

private:
    TString TracksApiName = "drive_graph";
    TString LinkerApiName = "default-linker";
    TString Format = "legacy";
    TDuration DurationThreshold;
    TDuration Fraction = TDuration::Minutes(5);
    TDuration TimeToLive;
    TString YtCluster;
    TString YtDirectory;
    ui32 BatchSize = 10000;
    ui32 MaxInFlight = 32;
    bool RidingOnly = false;

private:
    static TFactory::TRegistrator<TAnalyzerCacheProcess> Registrator;
};
