#pragma once

#include <drive/backend/rt_background/common/config.h>

class TTransformationConsistencyProcess: public IRTCarsProcess {
private:
    using TBase = IRTCarsProcess;

public:
    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "transformation_consistency";
    }

    virtual TExpectedState DoExecuteFiltered(TAtomicSharedPtr<IRTBackgroundProcessState> state, const NDrive::IServer& server, TTagsModificationContext& context) const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& value) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

private:
    TSeconds MaxSensorAge = TDuration::Minutes(2);
    TSeconds TelematicsTimeout = TDuration::Seconds(10);
    double RolloutFraction = 0;
    double SpeedThreshold = 1;

private:
    static TFactory::TRegistrator<TTransformationConsistencyProcess> Registrator;
};
