#pragma once
#include <drive/backend/rt_background/car_counter/config.h>
#include <drive/backend/rt_background/common/state.h>

#include <drive/backend/background/manager/regular.h>
#include <drive/backend/proto/background.pb.h>

#include <rtline/library/time_restriction/time_restriction.h>
#include <rtline/util/types/accessor.h>


class TRTCarTriggeredState : public TRTHistoryWatcherState {
public:
    virtual TString GetType() const;
private:
    static TFactory::TRegistrator<TRTCarTriggeredState> Registrator;
};


class TRTUserTriggeredState : public TRTHistoryWatcherState {
public:
    virtual TString GetType() const;
private:
    static TFactory::TRegistrator<TRTUserTriggeredState> Registrator;
};

class TRTTriggeredModificationWatcher: public IRTCarsProcess {
private:
    using TBase = IRTCarsProcess;
    class TTagOperation {
        R_READONLY(TString, TagName);
        R_READONLY(bool, RemoveTag, false);
    public:
        bool Apply(const TString& objectId, const TMap<TString, TVector<TDBTag>>& tagsByObject, TTagsModificationContext& context, const TRTTriggeredModificationWatcher& owner) const;
        TTagOperation(const TString& strDescription) {
            if (strDescription.StartsWith("+")) {
                TagName = strDescription.substr(1);
            } else if (strDescription.StartsWith("-")) {
                RemoveTag = true;
                TagName = strDescription.substr(1);
            } else {
                TagName = strDescription;
            }
        }
        TString ToString() const {
            return (RemoveTag ? "-" : "") + TagName;
        }
    };
    using TTagOperations = TMap<TString, TTagOperation>;
    R_READONLY(TTagOperations, TagOperations);
    R_READONLY(bool, DryRunMode, false);
    R_READONLY(TSet<TString>, RemovedTags);
    R_READONLY(TSet<TString>, NewTags);
    R_READONLY(TString, NotifierName);
    R_READONLY(TAreaTagsFilter, AreaTagsFilter);
    R_READONLY(bool, EmptyReport, false);

protected:
    virtual TExpectedState DoExecuteFiltered(TAtomicSharedPtr<IRTBackgroundProcessState> state, const NDrive::IServer& server, TTagsModificationContext& context) const override;
public:
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

private:
    virtual const TSet<TString>& GetFilteredObjectIds(const TTagsModificationContext& context) const = 0;
    virtual const IEntityTagsManager& GetEntityTagsManager(const NDrive::IServer& server) const = 0;
    virtual TRTHistoryWatcherState* BuildState() const = 0;
    virtual ITagsModificationContextImplBase& GetModification(TTagsModificationContext& context) const = 0;
};

class TCarTriggerWathcer : public TRTTriggeredModificationWatcher {
    using TBase = TRTTriggeredModificationWatcher;

public:
    using TBase::TBase;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "triggers_watcher";
    }

private:
    virtual const TSet<TString>& GetFilteredObjectIds(const TTagsModificationContext& context) const override;
    virtual const IEntityTagsManager& GetEntityTagsManager(const NDrive::IServer& server) const override;
    virtual TRTHistoryWatcherState* BuildState() const override {
        return new TRTCarTriggeredState();
    }
    virtual ITagsModificationContextImplBase& GetModification(TTagsModificationContext& context) const override {
        return context;
    }

private:
    static TFactory::TRegistrator<TCarTriggerWathcer> Registrator;
};


class TUserTriggerWathcer : public TRTTriggeredModificationWatcher {
    using TBase = TRTTriggeredModificationWatcher;

public:
    using TBase::TBase;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "user_triggers_watcher";
    }

private:
    virtual const TSet<TString>& GetFilteredObjectIds(const TTagsModificationContext& context) const override;
    virtual const IEntityTagsManager& GetEntityTagsManager(const NDrive::IServer& server) const override;
    virtual TRTHistoryWatcherState* BuildState() const override {
        return new TRTUserTriggeredState();
    }

    virtual ITagsModificationContextImplBase& GetModification(TTagsModificationContext& context) const override {
        if (!Modification || Modification->GetRobotUserId() != GetRobotUserId()) {
            Modification = MakeHolder<TUserTagsModificationContext>(GetRobotId(), GetRobotUserId(), context.GetServerAs<NDrive::IServer>());
        }
        return *Modification;
    }

private:
    static TFactory::TRegistrator<TUserTriggerWathcer> Registrator;
    mutable THolder<ITagsModificationContextImplBase> Modification;
};
