#include "deferred_verification.h"

TDeferredVerificationYangSender::TFactory::TRegistrator<TDeferredVerificationYangSender> TDeferredVerificationYangSender::Registrator(TDeferredVerificationYangSender::GetTypeName());

TExpectedState TDeferredVerificationYangSender::DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> /*state*/, const TExecutionContext& context) const {
    const NDrive::IServer* server = &context.GetServerAs<NDrive::IServer>();

    NYT::TNode::TListType list;
    try {
        list = YtClient->List(DeferredPoolsPath);
    } catch (const yexception& e) {
        MaybeNotify(server, "Не могу получить список отложенных пулов");
        return new IRTBackgroundProcessState();
    }

    for (auto&& i : list) {
        if (!i.IsMap()) {
            TString nodeName = i.AsString();

            TInstant moveInstant = TInstant::Zero();
            bool isParsed = false;
            if (TInstant::TryParseIso8601(nodeName, moveInstant)) {
                isParsed = true;
            }
            if (!isParsed) {
                ui64 timestamp;
                if (TryFromString(nodeName, timestamp)) {
                    moveInstant = TInstant::Seconds(timestamp);
                }
            }
            if (!isParsed || moveInstant > Now()) {
                continue;
            }

            TString path = DeferredPoolsPath + "/" + nodeName;
            TString pathMove = PoolsDestination + "/" + nodeName + "_" + ToString(RandomNumber<ui32>());

            try {
                YtClient->Move(path, pathMove);
            } catch (const yexception& e) {
                MaybeNotify(server, "Не могу переместить запланированный пул: " + path);
                continue;
            }
            MaybeNotify(server, "Переместили запланированный пул: " + path);
        }
    }

    return new IRTBackgroundProcessState();
}

void TDeferredVerificationYangSender::MaybeNotify(const NDrive::IServer* server, const TString& message) const {
    DEBUG_LOG << "Notification: " << message << Endl;
    if (NotifierName && server->GetNotifier(NotifierName)) {
        NDrive::INotifier::Notify(server->GetNotifier(NotifierName), message);
    }
}

NDrive::TScheme TDeferredVerificationYangSender::DoGetScheme(const IServerBase& server) const {
    NDrive::TScheme scheme = TBase::DoGetScheme(server);

    scheme.Add<TFSVariants>("notifier_name", "Способ нотификации").SetVariants(server.GetNotifierNames());
    scheme.Add<TFSString>("yt_cluster", "Кластер YT").SetRequired(true);
    scheme.Add<TFSString>("deferred_pools_path", "Директория с отложенными пулами").SetRequired(true);
    scheme.Add<TFSString>("pools_destination", "Куда класть пулы").SetRequired(true);

    return scheme;
}

NJson::TJsonValue TDeferredVerificationYangSender::DoSerializeToJson() const {
    NJson::TJsonValue result = TBase::DoSerializeToJson();

    TJsonProcessor::Write(result, "notifier_name", NotifierName);
    TJsonProcessor::Write(result, "yt_cluster", YtCluster);
    TJsonProcessor::Write(result, "deferred_pools_path", DeferredPoolsPath);
    TJsonProcessor::Write(result, "pools_destination", PoolsDestination);

    return result;
}

bool TDeferredVerificationYangSender::DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) {
    if (!TBase::DoDeserializeFromJson(jsonInfo)) {
        return false;
    }

    JREAD_STRING(jsonInfo, "notifier_name", NotifierName);
    JREAD_STRING(jsonInfo, "yt_cluster", YtCluster);
    JREAD_STRING(jsonInfo, "deferred_pools_path", DeferredPoolsPath);
    JREAD_STRING(jsonInfo, "pools_destination", PoolsDestination);

    YtClient = NYT::CreateClient(YtCluster, NYT::TCreateClientOptions());

    return true;
}
