#pragma once

#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/rt_background/manager/manager.h>

#include <drive/backend/database/drive_api.h>
#include <drive/backend/documents_verification/manager.h>
#include <drive/backend/registrar/ifaces.h>

#include <drive/library/cpp/scheme/scheme.h>

#include <mapreduce/yt/interface/client.h>

class TDeferredVerificationYangSender: public IRTRegularBackgroundProcess {
private:
    TString NotifierName;
    TString YtCluster;
    TString DeferredPoolsPath;
    TString PoolsDestination;

    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TDeferredVerificationYangSender> Registrator;

    TIntrusivePtr<NYT::IClient> YtClient;

    void MaybeNotify(const NDrive::IServer* server, const TString& message) const;

public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    static TString GetTypeName() {
        return "user_deferred_verification";
    }

    virtual TString GetType() const override {
        return GetTypeName();
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual NJson::TJsonValue DoSerializeToJson() const override;

    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
};
