#include "yang_tags_resend.h"

#include <drive/backend/data/user_tags.h>

TDocumentsVerificationYangTagsResend::TFactory::TRegistrator<TDocumentsVerificationYangTagsResend> TDocumentsVerificationYangTagsResend::Registrator("user_documents_yang_tags_resend");

TExpectedState TDocumentsVerificationYangTagsResend::DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> /*stateExt*/, const TExecutionContext& context) const {
    const NDrive::IServer* server = &context.GetServerAs<NDrive::IServer>();
    TVector<TDBTag> dbTags;
    auto session = server->GetDriveAPI()->template BuildTx<NSQL::Writable>();
    if (!server->GetDriveAPI()->GetTagsManager().GetUserTags().RestoreTags({}, {ResendToYangTagName}, dbTags, session)) {
        return MakeUnexpected<TString>("could not restore tags " + session.GetStringReport());
    }
    if (dbTags.size() > 0) {
        TSet<TString> documentsYangRecheck;
        for (auto&& tag : dbTags) {
            auto impl = tag.GetTagAs<TUserPhotoResendTag>();
            if (impl) {
                documentsYangRecheck.insert(impl->GetPhotoIds().begin(), impl->GetPhotoIds().end());
            }
        }
        TDocumentsVerificationManager manager(VerificationManagerConfig, server->GetDriveAPI()->GetDocumentPhotosManager());
        if (!manager.ResendToYangByPhotoIds(documentsYangRecheck, ResendToYangTagName, GetRobotUserId(), server, session) || !session.Commit()) {
            return MakeUnexpected<TString>("could not resend to yang " + session.GetStringReport());
        }
    }
    return new IRTBackgroundProcessState();
}

NDrive::TScheme TDocumentsVerificationYangTagsResend::DoGetScheme(const IServerBase& server) const {
    NDrive::TScheme scheme = TBase::DoGetScheme(server);
    scheme.Add<TFSString>("recheck_tag_name", "Имя тега для повторной отправки на проверку").SetRequired(false);
    scheme.Add<TFSString>("requests_path", "Путь к директории заданий").SetRequired(true);
    scheme.Add<TFSString>("yt_clusters", "Кластера YT (через запятую)").SetRequired(true);
    scheme.Add<TFSNumeric>("max_pool_size", "Максимальный возможный размер пула").SetRequired(true);
    return scheme;
}

NJson::TJsonValue TDocumentsVerificationYangTagsResend::DoSerializeToJson() const {
    NJson::TJsonValue result = TBase::DoSerializeToJson();
    NJson::InsertField(result, "recheck_tag_name", ResendToYangTagName);
    NJson::InsertField(result, "requests_path", VerificationManagerConfig.GetRequestsPath());
    NJson::InsertField(result, "yt_clusters", JoinStrings(VerificationManagerConfig.GetYtClusters(), ","));
    NJson::InsertField(result, "max_pool_size", VerificationManagerConfig.GetMaxPoolSize());
    return result;
}

bool TDocumentsVerificationYangTagsResend::DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) {
    if (!TBase::DoDeserializeFromJson(jsonInfo)) {
        return false;
    }
    TString ytClustersStr;
    if (!NJson::ParseField(jsonInfo, "yt_clusters", ytClustersStr)) {
        return false;
    }
    VerificationManagerConfig.MutableYtClusters() = SplitString(ytClustersStr, ",");
    VerificationManagerConfig.MutableGeo().emplace("*");
    return
        NJson::ParseField(jsonInfo, "requests_path", VerificationManagerConfig.MutableRequestsPath(), true) &&
        NJson::ParseField(jsonInfo, "recheck_tag_name", ResendToYangTagName) &&
        NJson::ParseField(jsonInfo, "max_pool_size", VerificationManagerConfig.MutableMaxPoolSize(), true);
}
