#pragma once

#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/rt_background/manager/manager.h>

#include <drive/backend/database/drive_api.h>
#include <drive/backend/documents_verification/manager.h>
#include <drive/backend/proto/background.pb.h>

#include <drive/library/cpp/scheme/scheme.h>

#include <mapreduce/yt/interface/client.h>

class TDocumentsVerificationYangTagsResend: public IRTRegularBackgroundProcess {
private:
    R_READONLY(TDocumentsVerificationConfig, VerificationManagerConfig);
    R_READONLY(TString, ResendToYangTagName);

private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TDocumentsVerificationYangTagsResend> Registrator;

public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> stateExt, const TExecutionContext& context) const override;

    static TString GetTypeName() {
        return "user_documents_yang_tags_resend";
    }

    virtual TString GetType() const override {
        return GetTypeName();
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual NJson::TJsonValue DoSerializeToJson() const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
};
