#pragma once

#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/rt_background/manager/manager.h>

#include <drive/backend/database/drive_api.h>
#include <drive/backend/documents_verification/manager.h>
#include <drive/backend/proto/background.pb.h>

#include <drive/library/cpp/scheme/scheme.h>

#include <mapreduce/yt/interface/client.h>

class TRTDocumentsVerificationTasksCreatorState : public IProtoStateSerializable<NDrive::NProto::TDocumentsVerificationTasksCreatorState> {
private:
    using TBase = IProtoStateSerializable<NDrive::NProto::TDocumentsVerificationTasksCreatorState>;

    static TFactory::TRegistrator<TRTDocumentsVerificationTasksCreatorState> Registrator;

    R_FIELD(TInstant, LastProcessedInstant, TInstant::Zero());

protected:
    virtual void SerializeToProto(NDrive::NProto::TDocumentsVerificationTasksCreatorState& proto) const override {
        proto.SetLastProcessedTimestamp(LastProcessedInstant.Seconds());
    }

    virtual bool DeserializeFromProto(const NDrive::NProto::TDocumentsVerificationTasksCreatorState& proto) override {
        LastProcessedInstant = TInstant::Seconds(proto.GetLastProcessedTimestamp());
        return true;
    }

public:
    using TBase::TBase;

    virtual NJson::TJsonValue GetReport() const override {
        NJson::TJsonValue result = TBase::GetReport();
        JWRITE(result, "last_processed_timestamp", LastProcessedInstant.Seconds());
        return result;
    }

    virtual NDrive::TScheme DoGetScheme() const override {
        NDrive::TScheme result = TBase::DoGetScheme();
        result.Add<TFSNumeric>("last_processed_timestamp");
        return result;
    }

    TString GetType() const override;
};

class TDocumentsVerificationYangTasksCreatorTagsOnly: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TDocumentsVerificationYangTasksCreatorTagsOnly> Registrator;

protected:
    R_READONLY(TDocumentsVerificationConfig, VerificationManagerConfig);
    R_READONLY(TString, ResendToYangTagName);

protected:
    void ResendTagsToYang(const NDrive::IServer* server, const TDocumentsVerificationManager& manager) const;

public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> /* stateExt */, const TExecutionContext& context) const override;

    static TString GetTypeName() {
        return "user_documents_yang_tasks_creator_tags_only";
    }

    virtual TString GetType() const override {
        return GetTypeName();
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual NJson::TJsonValue DoSerializeToJson() const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
};

class TDocumentsVerificationYangTasksCreator: public TDocumentsVerificationYangTasksCreatorTagsOnly {
private:
    R_READONLY(TDuration, LastAssignmentFreshness, TDuration::Days(10));

private:
    using TTagsOnlyBase = TDocumentsVerificationYangTasksCreatorTagsOnly;
    static TFactory::TRegistrator<TDocumentsVerificationYangTasksCreator> Registrator;

public:
    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> stateExt, const TExecutionContext& context) const override;

    static TString GetTypeName() {
        return "user_documents_yang_tasks_creator";
    }

    virtual TString GetType() const override {
        return GetTypeName();
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual NJson::TJsonValue DoSerializeToJson() const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
};
