#pragma once

#include <drive/backend/database/drive_api.h>
#include <drive/backend/rt_background/manager/settings.h>

#include <rtline/util/types/accessor.h>


class TRTUserInsuranceWatcher: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;
    using TStateMap = TMap<TString, TDuration>;

private:
    static TFactory::TRegistrator<TRTUserInsuranceWatcher> Registrator;

public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "user_insurance_watcher";
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

private:
    R_FIELD(TSet<TString>, TagNames);
    R_FIELD(TStateMap, CleanMap);
};
