#pragma once

#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/rt_background/manager/manager.h>

#include <drive/backend/tags/tags_filter.h>

#include <drive/library/cpp/scheme/scheme.h>

class TRTUserPushSenderCounter: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;

private:
    R_READONLY(TString, Notifier);
    R_READONLY(TString, ExternalNotifier);
    R_READONLY(ui32, PackSize, 1000);
    R_READONLY(ui32, MaxPacksPerTag, 10);
    R_READONLY(TDuration, PacksInterval, TDuration::Seconds(30));
    R_READONLY(TString, MessageTagType, "user_push");
    R_READONLY(TSet<TString>, MessageTagNames);
    R_READONLY(TString, SubscriptionStatusTag, "user_app_settings");
    R_READONLY(TString, SubscriptionStatusField, "notifications_push");

private:
    static TFactory::TRegistrator<TRTUserPushSenderCounter> Registrator;

public:
    virtual TString GetType() const override {
        return "user_push_sender";
    }

    using TBase::TBase;

protected:
    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
};
