#include "sessions_refresh.h"

#include <drive/backend/rt_background/manager/state.h>

#include <drive/backend/database/drive_api.h>
#include <drive/backend/head/head_account.h>

IRTRegularBackgroundProcess::TFactory::TRegistrator<TRTSessionsRefreshWatcher> TRTSessionsRefreshWatcher::Registrator(TRTSessionsRefreshWatcher::GetTypeName());


TExpectedState TRTSessionsRefreshWatcher::DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> /*stateExt*/, const TExecutionContext& context) const {
    const NDrive::IServer& server = context.GetServerAs<NDrive::IServer>();
    const TShortSessionsManager& manager = server.GetDriveAPI()->GetShortSessionsManager();
    auto session = server.GetDriveAPI()->template BuildTx<NSQL::Writable>();

    auto defaultInfo = manager.GetUserSession("default");
    if (!defaultInfo.Defined()) {
        manager.StartSession("default", session);
    }

    if (!manager.ResetSessions(session, GetRobotUserId(), ExpirationDelta) || !session.Commit()) {
        ERROR_LOG << "Can't refresh ya_auto sessions" << Endl;
        return MakeUnexpected<TString>({});
    }
    return MakeAtomicShared<IRTBackgroundProcessState>();
}

NDrive::TScheme TRTSessionsRefreshWatcher::DoGetScheme(const IServerBase& server) const {
    auto scheme = TBase::DoGetScheme(server);
    scheme.Add<TFSNumeric>("expiration_delta", "Точность (sec)").SetDefault(10);
    return scheme;
}

bool TRTSessionsRefreshWatcher::DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) {
    JREAD_DURATION(jsonInfo, "expiration_delta", ExpirationDelta);
    return TBase::DoDeserializeFromJson(jsonInfo);
}

NJson::TJsonValue TRTSessionsRefreshWatcher::DoSerializeToJson() const {
    auto json = TBase::DoSerializeToJson();
    JWRITE_DURATION(json, "expiration_delta", ExpirationDelta);
    return json;
}
